/* globals URI, $ */

import Route from 'ember-route';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

export default Route.extend({
  clips: injectService(),
  globals: injectService(),
  layout: injectService(),
  isInMaintenanceMode: computed.alias('globals.isInMaintenanceMode'),

  ttLocation: 'directory',

  beforeModel() {
    this._super(...arguments);

    return this.get('clips').checkClipsTabOnGameDirExperiment();
  },

  activate() {
    this.set('layout.showRightColumn', true);

    let url = URI(window.location);
    let isInMaintenanceMode = this.get('isInMaintenanceMode');

    if (isInMaintenanceMode && url.query(true).maintenance) {
      $.login();
      url.removeQuery('maintenance');
      if (window.history && window.history.replaceState) {
        window.history.replaceState({}, "", url.resource());
      }
    }
  },

  deactivate() {
    this.set('layout.showRightColumn', false);
  }
});
