/* globals _ */

import Route from 'ember-route';
import RSVP from 'rsvp';
import injectService from 'ember-service/inject';
import StreamModel from 'web-client/models/deprecated-stream';
import { isFollowingColumnInteractive } from 'web-client/utilities/interactivity';

export default Route.extend({
  tracking: injectService(),

  model(params) {
    return StreamModel.find('top', {broadcaster_language: params.broadcaster_language});
  },

  afterModel(model) {
    model.load();
    this._super(...arguments);
  },

  isInteractive(interactiveComponents) {
    return isFollowingColumnInteractive(interactiveComponents) && (
      interactiveComponents['stream-preview'] ||
      interactiveComponents['beacon:no-broadcaster-language-channels-are-live']
    );
  },

  trackPageView(properties) {
    this.get('tracking.funnel').trackPageViewWithDiagnostics(
      RSVP.hash({
        'num_language_channels': this.controllerFor('directory/channels/all').get('languageChannelsCountPromise')
      }).then(function (results) {
        return _.defaults(properties, results);
      })
    );
  }
});
