/* globals i18n */

import Route from 'ember-route';
import StreamModel from 'web-client/models/deprecated-stream';
import injectService from 'ember-service/inject';
import { CREATIVE } from 'web-client/utilities/game-names';
import { isFollowingColumnInteractive } from 'web-client/utilities/interactivity';

export default Route.extend({
  languageDirectoryFilter: injectService(),

  isInteractive(interactiveComponents) {
    return isFollowingColumnInteractive(interactiveComponents) && (
      interactiveComponents['stream-preview'] ||
      interactiveComponents['beacon:no-directory-channels-are-live'] ||
      interactiveComponents['beacon:no-channels-directory-channels-are-live']
    );
  },

  renderTemplate(controller, model) {
    this._super(...arguments);
    this.render('directory/channels/all', {model: model});
  },

  model() {
    return StreamModel.find('bygame', { game: CREATIVE }).load();
  },

  afterModel() {
    this.set('languageDirectoryFilter.gameName', CREATIVE);
    this._super(...arguments);
  },

  buildPageTitle() {
    return {title: i18n('Top Channels From Creative')};
  }
});
