/* globals i18n */

import Route from 'ember-route';
import StreamModel from 'web-client/models/deprecated-stream';
import { isFollowingColumnInteractive } from 'web-client/utilities/interactivity';

export default Route.extend({
  isInteractive(interactiveComponents) {
    return isFollowingColumnInteractive(interactiveComponents) && (
      interactiveComponents['stream-preview'] ||
      interactiveComponents['beacon:no-directory-channels-are-live'] ||
      interactiveComponents['beacon:no-channels-directory-channels-are-live']
    );
  },

  renderTemplate(controller, model) {
    this._super();
    this.render('directory/channels/all', {controller: 'directory/channels/all', model: model});
  },

  model() {
    return StreamModel.find('psFour').load();
  },

  buildPageTitle() {
    return {title: i18n('Top Channels From PlayStation 4')};
  }
});
