/* globals i18n */

import Route from 'ember-route';
import StreamModel from 'web-client/models/deprecated-stream';
import { isFollowingColumnInteractive } from 'web-client/utilities/interactivity';

export default Route.extend({
  model() {
    return StreamModel.find('random').load();
  },

  buildPageTitle() {
    return {title: i18n('Random Channels')};
  },

  isInteractive(interactiveComponents) {
    return isFollowingColumnInteractive(interactiveComponents) && (
      interactiveComponents['stream-preview'] ||
      interactiveComponents['beacon:random-channels-directory-no-channels-are-live']
    );
  }
});
