/* globals i18n */

import Route from 'ember-route';
import StreamModel from 'web-client/models/deprecated-stream';
import { isFollowingColumnInteractive } from 'web-client/utilities/interactivity';

export default Route.extend({
  renderTemplate(controller, model) {
    this._super();
    this.render('directory/channels/all', {controller: 'directory/channels/all', model: model});
  },

  isInteractive(interactiveComponents) {
    return isFollowingColumnInteractive(interactiveComponents) && (
      interactiveComponents['stream-preview'] ||
      interactiveComponents['beacon:no-directory-channels-are-live'] ||
      interactiveComponents['beacon:no-channels-directory-channels-are-live']
    );
  },

  model() {
    return StreamModel.find('xbOne').load();
  },

  buildPageTitle() {
    return {title: i18n('Top Channels From Xbox One')};
  }
});
