/* globals SiteOptions, i18n */

import computed from 'ember-computed';
import DeprecatedGameModel from 'web-client/models/deprecated-game';
import injectService from 'ember-service/inject';
import Route from 'ember-route';
import RSVP from 'rsvp';
import { CREATIVE } from 'web-client/utilities/game-names';
import env from 'web-client/config/environment';

export default Route.extend({
  api: injectService(),
  store: injectService(),
  navigation: injectService(),
  communities: injectService(),

  activate() {
    this.get('navigation').setSelected('Creative');
  },

  channels: computed(function () {
    if (!SiteOptions.creative_featured_channels) {
      return [];
    }
    return SiteOptions.creative_featured_channels.split(',');
  }),

  model() {
    return RSVP.hash({
      game: DeprecatedGameModel.findByName(this.get('api'), CREATIVE),
      tags: this.get('store').query('community', { game: CREATIVE, limit: 100, sortBy: 'viewers' }),
      communities: this.get('api').request('get', '/api/aggregates/Creative', {}, {host: env.creative.aggregator.host}).then(result => {
        return result.aggregate.communities;}),
      currentTag: null,
      channels: this.get('channels')
    });
  },

  buildPageTitle() {
    return {title: i18n('Creative')};
  }
});
