import Route from 'ember-route';
import injectService from 'ember-service/inject';
import ChannelModel from 'web-client/models/deprecated-channel';

export default Route.extend({
  api: injectService(),
  queryParams: {
    tag: {
      refreshModel: true
    }
  },
  redirect(_, transition) {
    let tag = transition.params['directory.creative.hashtag'].tag;
    return this.get('api').request('get', `/kraken/streams/communities/${tag}?game=Creative`).then(response => {
      if (response.streams[0]) {
        return this.transitionTo('channel', ChannelModel.find({id: response.streams[0].channel.display_name}).load());
      }
      return this.transitionTo('directory.creative.hashtag', tag);
    }, () => {
      return this.transitionTo('directory.creative.hashtag', tag);
    });
  }
});
