import Route from 'ember-route';
import { CHANNELS, VODS, COMMUNITIES } from 'web-client/components/tag-streams';
import RSVP from 'rsvp';
import { isFollowingColumnInteractive } from 'web-client/utilities/interactivity';

export default Route.extend({
  model() {
    let parentModel = this.modelFor('directory.creative');

    return RSVP.hash({
      game: parentModel.game,
      channels: parentModel.channels,
      communities: parentModel.communities,
      streamTypes: { CHANNELS, VODS, COMMUNITIES }
    });
  },

  isInteractive(interactiveComponents) {
    return isFollowingColumnInteractive(interactiveComponents) &&
      interactiveComponents['creative-spotlight'] && (
        interactiveComponents['community-preview'] ||
        interactiveComponents['stream-preview'] ||
        interactiveComponents['beacon:no-tag-streams-channels-live']
      );
  }
});
