/* globals Twitch, _ */

import Route from 'ember-route';
import RSVP from 'rsvp';
import injectService from 'ember-service/inject';
import DeprecatedGameModel from 'web-client/models/deprecated-game';
import { CSGO } from 'web-client/utilities/game-names';

export default Route.extend({
  clips: injectService(),
  vodGameInfo: injectService(),
  csgoLanguageSample: injectService(),
  api: injectService(),

  beforeModel() {
    this._super(...arguments);

    let vodGameInfo = this.get('vodGameInfo').checkExperiment();
    let csgoLanguageSample = this.get('csgoLanguageSample').checkExperiment();
    return RSVP.all([vodGameInfo, csgoLanguageSample]);
  },

  model() {
    return DeprecatedGameModel.findByName(this.get('api'), CSGO);
  },

  trackPageView: function (properties) {
    Twitch.tracking.funnel.trackPageView(_.defaults(properties, {
      game: CSGO
    }));
  },

  actions: {
    dismissClipsGameUpsell() {
      this.get('clips').dismissGameUpsell();
    }
  }
});
