/* globals Twitch, SiteOptions, _ */

import Route from 'ember-route';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import StreamModel from 'web-client/models/deprecated-stream';

export default Route.extend({
  csgoLanguageSample: injectService(),
  excludedLocalizedContentLanguages: computed.alias('globals.excludedLocalizedContentLanguages'),

  queryParams: {
    sortBy: {
      refreshModel: true,
      replace: true
    }
  },

  renderTemplate() {
    this._super(this, arguments);

    if (this.get('csgoLanguageSample.isEnabled')) {
      this.set('usePageViewPromise', false);

      if (Twitch.receivedLanguage) {
        let twoLetterLanguageCode = Twitch.receivedLanguage.slice(0, 2);
        let excludedLocalizedContentLanguages = this.get('excludedLocalizedContentLanguages');

        if (!_.contains(excludedLocalizedContentLanguages, twoLetterLanguageCode) &&
            _.contains(_.keys(SiteOptions.broadcaster_languages), twoLetterLanguageCode)) {
          this.set('usePageViewPromise', true);

          this.render('directory/game/channels/broadcaster-language-sample', {
            outlet: 'localizedContent',
            into: 'directory/csgo/channels',
            controller: 'directory/game/broadcaster-language',
            model: StreamModel.find('bygame', {
              game: this.modelFor('directory.csgo').get('id'),
              broadcaster_language: twoLetterLanguageCode
            }).load()
          });
        }
      }
    }
  },

  model(params) {
    return StreamModel.find('csgo', {cs_map: params.map, order: params.sortBy});
  },

  afterModel(model) {
    model.load();
    this._super(...arguments);
  }
});
