import Route from 'ember-route';
import injectService from 'ember-service/inject';
import DeprecatedVideo from 'web-client/models/deprecated-video';
import { CSGO } from 'web-client/utilities/game-names';

export default Route.extend({
  languageDirectoryFilter: injectService(),

  model() {
    let languages = this.get('languageDirectoryFilter.languageFilters').join(',');
    return DeprecatedVideo.find('game', {
      game: CSGO,
      language: languages
    });
  },

  afterModel(model) {
    model.load();
    this._super(...arguments);
  }
});
