import Route from 'ember-route';
import injectService from 'ember-service/inject';
import RSVP from 'rsvp';
import { isFollowingColumnInteractive } from 'web-client/utilities/interactivity';

const MIN_COMPONENTS_TO_SHOW = 4;

export default Route.extend({
  recommendationLanguages: injectService(),
  similarChannels: injectService(),
  recentlyWatchedStreams: injectService(),
  trendingVideos: injectService(),
  newReleases: injectService(),
  storage: injectService(),
  navigation: injectService(),
  experiments: injectService(),

  isInteractive(interactiveComponents) {
    let isDiscoverDirectoryInteractive = interactiveComponents['beacon:discover-directory-no-recommendations'] ||
      interactiveComponents['beacon:discover-directory-recommendations'];

    return isFollowingColumnInteractive(interactiveComponents) && isDiscoverDirectoryInteractive;
  },

  userLanguages: [],

  activate() {
    this.get('navigation').setSelected('Discovery');
  },

  beforeModel() {
    this._super(...arguments);

    let recommendationLanguages = this.get('recommendationLanguages');
    return recommendationLanguages.getRecommendationLanguages().then((languages) => {
      this.set('userLanguages', languages);
    });
  },

  model() {
    let userLanguages = this.get('userLanguages');
    let recentlyWatchedStreams = this.get('recentlyWatchedStreams');
    let trendingVideos = this.get('trendingVideos');
    let newReleases = this.get('newReleases');

    let recentStreams = this.get('experiments').getExperimentValue('DISCOVER_HIDE_RECENTLY_WATCHED_STREAMS').then((value) => {
      if (value === 'show') {
        return recentlyWatchedStreams.getRecentlyWatchedStreams();
      }
      return [];
    });

    let videosTrending = this.get('experiments').getExperimentValue('DISCOVER_HIDE_RECENTLY_WATCHED_STREAMS').then((value) => {
      if (value === 'show') {
        return trendingVideos.getTrendingVideos(userLanguages);
      }
      return [];
    });

    let gamesNewReleases = this.get('experiments').getExperimentValue('DISCOVER_HIDE_RECENTLY_WATCHED_STREAMS').then((value) => {
      if (value === 'show') {
        return newReleases.getGamesNewReleases(userLanguages);
      }
      return [];
    });

    return RSVP.hash({
      similarChannels: this.modelFor('application').findSimilarChannels,
      recentlyWatchedStreams: recentStreams,
      trendingVideos: videosTrending,
      gamesNewReleases: gamesNewReleases
    });
  },

  setupController(controller, model) {
    this._super(controller, model);
    controller.set('showRecentlyWatchedStreams', model.recentlyWatchedStreams.length >= MIN_COMPONENTS_TO_SHOW);
    controller.set('showTrendingVideos', model.trendingVideos.length >= MIN_COMPONENTS_TO_SHOW);
  }
});
