import $ from 'jquery';
import Route from 'ember-route';
import injectService from 'ember-service/inject';
import RSVP from 'rsvp';

export default Route.extend({
  api: injectService(),
  layout: injectService(),
  vodGameInfo: injectService(),
  similarChannels: injectService(),
  session: injectService(),
  paginator: injectService(),
  navigation: injectService(),

  activate() {
    this.get('navigation').setSelected('Following');
    this.set('layout.showRightColumn', false);

    if (!this.get('session.isAuthenticated')) {
      $.login({ mpSourceAction: 'page-requires-login' });
    }
  },

  deactivate() {
    this.set('layout.showRightColumn', true);
  },

  beforeModel() {
    this._super(...arguments);

    return RSVP.all([
      this.get('vodGameInfo').checkExperiment(),
      this.get('similarChannels').findRecommendations()
    ]);
  },

  model() {
    let { isAuthenticated, userData } = this.get('session');
    if (isAuthenticated) {
      return this.store.findRecord('channel', userData.login).then((channel) => {
        return this.get('paginator').paginatorFor({
          model: channel,
          relationshipName: 'directoryFollowing',
          pageFactory: 'follow'
        }).fetchNextPage();
      });
    }
  }
});
