/* globals i18n, _ */

import Route from 'ember-route';
import injectService from 'ember-service/inject';
import FollowingDirectoryRouteTrackingMixin from 'web-client/mixins/following-directory-route-tracking';
import StreamModel from 'web-client/models/deprecated-stream';
import { isFollowingChannelsDirectoryInteractive } from 'web-client/utilities/interactivity';

export default Route.extend(FollowingDirectoryRouteTrackingMixin, {
  session: injectService(),
  tracking: injectService(),

  isInteractive(interactiveComponents) {
    let { isAuthenticated } = this.get('session');

    if (isAuthenticated) {
      return isFollowingChannelsDirectoryInteractive(interactiveComponents);
    }
    return interactiveComponents['beacon:following-directory-logged-out'];
  },

  model() {
    return StreamModel.find('live').load();
  },

  buildPageTitle() {
    return {title: i18n('Channels You Follow')};
  },

  trackPageView(properties) {
    this.get('tracking.funnel').trackPageViewWithDiagnostics(
      this.controllerFor('directory/following').get('followingCountPromise').then(function (followingCount) {
        return _.defaults(properties, {
          'content_type': 'channels',
          'tab': 'channels',
          'num_live_channels': followingCount,
          'num_live_channels_displayed': followingCount
        });
      })
    );
  },

  trackingData() {
    return {
      'tab': 'channels',
      'num_channels': this.controllerFor('directory/following/channels').get('content.length')
    };
  }
});
