/* globals i18n, _ */

import Route from 'ember-route';
import injectService from 'ember-service/inject';
import FollowingDirectoryRouteTrackingMixin from 'web-client/mixins/following-directory-route-tracking';
import DeprecatedGameModel from 'web-client/models/deprecated-game';

export default Route.extend(FollowingDirectoryRouteTrackingMixin, {
  session: injectService(),
  tracking: injectService(),

  isInteractive(interactiveComponents) {
    let { isAuthenticated } = this.get('session');
    let hasGameFollows = this.get('controller.hasGameFollows');
    let hasLiveGames = this.get('controller.hasLiveGames');

    if (isAuthenticated) {
      if (hasGameFollows) {
        if (hasLiveGames) {
          return interactiveComponents['directory-game'];
        }
        return interactiveComponents['beacon:following-directory-no-live-games'];
      }
      return interactiveComponents['directory-games-following-none'];
    }
    return interactiveComponents['beacon:following-directory-logged-out'];
  },

  model() {
    return DeprecatedGameModel.find('liveFollows').load();
  },

  buildPageTitle() {
    return {title: i18n('Games You Follow')};
  },

  trackPageView(properties) {
    this.get('tracking.funnel').trackPageViewWithDiagnostics(
      this.controllerFor('directory/following').get('followingGamesCountPromise').then(function (followingGamesCount) {
        return _.defaults(properties, {
          'content_type': 'games',
          'tab': 'games',
          'num_live_games': followingGamesCount,
          'num_live_games_displayed': followingGamesCount
        });
      })
    );
  },

  trackingData() {
    return {
      'tab': 'games',
      'num_games': this.controllerFor('directory/following/games').get('content.length')
    };
  }
});
