/* globals i18n, _ */

import Route from 'ember-route';
import injectService from 'ember-service/inject';
import FollowingDirectoryRouteTrackingMixin from 'web-client/mixins/following-directory-route-tracking';
import HostModel from 'web-client/models/host';
import { isFollowingHostsDirectoryInteractive } from 'web-client/utilities/interactivity';

export default Route.extend(FollowingDirectoryRouteTrackingMixin, {
  session: injectService(),
  tracking: injectService(),

  isInteractive(interactiveComponents) {
    let { isAuthenticated } = this.get('session');

    if (isAuthenticated) {
      return isFollowingHostsDirectoryInteractive(interactiveComponents);
    }
    return interactiveComponents['beacon:following-directory-logged-out'];
  },

  model() {
    return HostModel.find('following').load();
  },

  buildPageTitle() {
    return {title: i18n('Hosts You Follow')};
  },

  trackPageView(properties) {
    this.get('tracking.funnel').trackPageViewWithDiagnostics(
      this.controllerFor('directory/following').get('followingHostsCountPromise').then(function (followingHostsCount) {
        return _.defaults(properties, {
          'content_type': 'hosts',
          'tab': 'hosts',
          'num_host_channels': followingHostsCount,
          'num_host_channels_displayed': followingHostsCount
        });
      })
    );
  },

  trackingData() {
    return {
      'tab': 'hosts',
      'num_hosts': this.controllerFor('directory/following/hosts').get('content.length')
    };
  }
});
