/* globals i18n, _ */

import Route from 'ember-route';
import RSVP from 'rsvp';
import injectService from 'ember-service/inject';
import FollowingDirectoryRouteTrackingMixin from 'web-client/mixins/following-directory-route-tracking';
import DeprecatedGame from 'web-client/models/deprecated-game';
import Host from 'web-client/models/host';
import Stream from 'web-client/models/deprecated-stream';
import DeprecatedVideo from 'web-client/models/deprecated-video';
import { isFollowingChannelsDirectoryInteractive, isFollowingHostsDirectoryInteractive } from 'web-client/utilities/interactivity';

export default Route.extend(FollowingDirectoryRouteTrackingMixin, {
  session: injectService(),
  tracking: injectService(),
  vodCoviews: injectService(),

  isInteractive(interactiveComponents) {
    let { isAuthenticated } = this.get('session');

    if (isAuthenticated) {
      let channelsRendered = isFollowingChannelsDirectoryInteractive(interactiveComponents);

      let areVodsViewable = this.get('vodCoviews.areVodsViewable');
      let recsOrHost = areVodsViewable ? interactiveComponents['video/coviews/directory-container'] : isFollowingHostsDirectoryInteractive(interactiveComponents);

      let isFollowingAboveHost = this.get('vodCoviews.isFollowingAboveHost');
      let recsOrUploads = isFollowingAboveHost ? recsOrHost : interactiveComponents['video/following-uploads'];
      return channelsRendered && recsOrUploads;
    }
    return interactiveComponents['beacon:following-directory-logged-out'];
  },

  renderTemplate() {
    this._super(this, arguments);
    this.render('directory/following/channelssample', {
      outlet: 'channels',
      into: 'directory/following/index',
      controller:'directory/following/channels',
      model: Stream.find('live').load()
    });
    this.render('directory/following/hostssample', {
      outlet: 'hosts',
      into: 'directory/following/index',
      controller:'directory/following/hosts',
      model: Host.find('following').load()
    });
    this.render('directory/following/gamessample', {
      outlet: 'games',
      into: 'directory/following/index',
      controller:'directory/following/games',
      model: DeprecatedGame.find('liveFollows').load()
    });
    this.render('directory/following/videossample', {
      outlet: 'videos',
      into: 'directory/following/index',
      controller:'directory/following/videos',
      model: DeprecatedVideo.find('following').load()
    });
  },

  beforeModel() {
    this._super(...arguments);
    return this.get('vodCoviews').checkExperiment().then(() => {
      return this.get('vodCoviews').findVodCoviews();
    });
  },

  buildPageTitle() {
    return {title: i18n('Following')};
  },

  trackPageView(properties) {
    this.get('tracking.funnel').trackPageViewWithDiagnostics(
      RSVP.hash({
        'num_host_channels': this.controllerFor('directory/following').get('followingHostsCountPromise'),
        'num_live_channels': this.controllerFor('directory/following').get('followingCountPromise'),
        'num_live_games': this.controllerFor('directory/following').get('followingGamesCountPromise'),
        'num_videos': this.controllerFor('directory/following').get('followingVideosCountPromise')
      }).then((results) => {
        let trackingData = this.trackingData();
        return _.extend(results, {
          'content_type': 'mixed',
          'tab': trackingData.tab,
          'num_host_channels_displayed': trackingData.num_hosts,
          'num_live_channels_displayed': trackingData.num_channels,
          'num_live_games_displayed': trackingData.num_games,
          'num_videos_displayed': trackingData.num_videos
        }, properties);
      })
    );
  },

  trackingData() {
    return {
      'tab': 'overview',
      'num_channels': this.controllerFor('directory/following/channels').get('sampleStreams.length'),
      'num_videos': this.controllerFor('directory/following/videos').get('sampleVideos.length'),
      'num_hosts': this.controllerFor('directory/following/hosts').get('sampleHosts.length'),
      'num_games': this.controllerFor('directory/following/games').get('sampleGames.length')
    };
  }
});
