/* globals i18n, _ */

import Route from 'ember-route';
import injectService from 'ember-service/inject';
import FollowingDirectoryRouteTrackingMixin from 'web-client/mixins/following-directory-route-tracking';

export default Route.extend(FollowingDirectoryRouteTrackingMixin, {
  tracking: injectService(),
  vodCoviews: injectService(),

  beforeModel() {
    this._super(...arguments);

    return this.get('vodCoviews').checkExperiment().then(() => {
      return this.get('vodCoviews').findVodCoviews();
    });
  },

  buildPageTitle() {
    return {title: i18n('Videos You Follow')};
  },

  trackPageView(properties) {
    this.get('tracking.funnel').trackPageViewWithDiagnostics(
      this.controllerFor('directory/following').get('followingVideosCountPromise').then(function (followingVideosCount) {
        return _.defaults(properties, {
          'content_type': 'vods',
          'tab': 'videos',
          'num_videos': followingVideosCount,
          'num_videos_displayed': followingVideosCount
        });
      })
    );
  },

  trackingData() {
    return {
      'tab': 'videos',
      'num_videos': this.controllerFor('directory/following/videos').get('content.length')
    };
  }
});
