import Route from 'ember-route';
import injectService from 'ember-service/inject';
import VideoTypeMixin from 'web-client/mixins/video-type';
import { SORT_TIME_TYPE } from 'web-client/utilities/video/sorts';

export default Route.extend(VideoTypeMixin, {
  recsHoldout: injectService(),
  session: injectService(),

  sort: SORT_TIME_TYPE,

  isInteractive(interactiveComponents) {
    let { isAuthenticated } = this.get('session');

    if (isAuthenticated) {
      let recsShownIfNeeded = this.get('recsHoldout.shouldShowRecs') ? interactiveComponents['video/coviews/directory-container'] : true;
      return recsShownIfNeeded && interactiveComponents['directory/videos/videos-list'];
    }
    return interactiveComponents['beacon:following-directory-logged-out'];
  },

  model({ videoType }) {
    return this._modelForVideoType({
      videoType,
      defaultRoute: 'directory.following.videos.video-type',
      searchParams: {},
      videoCollection: 'following'
    });
  }
});
