/* globals Twitch, i18n */

import Route from 'ember-route';
import injectService from 'ember-service/inject';
import urlParams from 'web-client/utilities/url-params';

export default Route.extend({
  store: injectService(),
  gameSettings: injectService(),
  notify: injectService(),
  urlParams,

  init() {
    this._super(...arguments);
    this._name = null;
  },

  beforeModel() {
    this._super(...arguments);

    if (this.get('urlParams.redeemed')){
      this.get('notify').success(i18n('You have successfully claimed this benefit.'));
    }
  },

  model(params) {
    this._name = params.game_id;
    return this.get('store').queryRecord('game-detail', {
      game: this._name
    });
  },

  actions: {
    error(error, transition) {
      if (error) {
        transition.abort();
        return this.transitionTo('404', `directory/game/${this._name}/details`);
      }
    }
  },

  setupController(controller) {
    this._super(...arguments);

    let brName = this.get('urlParams.br_name');
    if (brName) {
      this.get('gameSettings').getUserInfo(brName).then(response => {
        controller.set('broadcasterName', response.display_name);
        controller.set('broadcasterId', response._id);
        controller.set('broadcasterLogo', response.logo);
      });
    }
  },

  buildPageTitle() {
    return {
      title: `${this._name} - Watch Live Streams on Twitch`
    };
  },

  trackPageView(properties) {
    properties.location = 'game_detail';
    Twitch.tracking.funnel.trackPageView(properties);
  }
});
