/* globals Twitch, _ */

import Route from 'ember-route';
import RSVP from 'rsvp';
import StreamModel from 'web-client/models/deprecated-stream';
import injectService from 'ember-service/inject';

export default Route.extend({
  community: injectService(),

  model(params) {
    let game = this.modelFor('directory.game').get('id');
    let findBy = this.get('community').isCreativeManagedGame(game) ? "gameWithCommunity" : "bygame";

    return StreamModel.find(findBy, {
      game,
      broadcaster_language: params.broadcaster_language
    });
  },

  afterModel(model) {
    model.load();
    this._super(...arguments);
  },

  trackPageView(properties) {
    let self = this;
    Twitch.tracking.funnel.trackPageViewWithDiagnostics(
      RSVP.hash({
        'num_language_channels': this.controllerFor('directory.game').get('languageChannelsCountPromise')
      }).then(function (results) {
        return _.defaults(properties, results, {
          'game': self.controllerFor('directory.game').get('content.id')});
      })
    );
  }
});
