import Route from 'ember-route';
import injectService from 'ember-service/inject';
import VideoTypeMixin from 'web-client/mixins/video-type';

export default Route.extend(VideoTypeMixin, {
  experiments: injectService(),

  model({ videoType }) {
    let game = this.modelFor('directory.game').get('id');
    let typedVideo = this._modelForVideoType({
      videoType,
      defaultRoute: 'directory.game.videos.video-type',
      videoCollection: 'game',
      searchParams: { game }
    });

    return {
      typedVideo,
      game
    };
  }
});
