/* globals i18n */

import Route from 'ember-route';
import { isEmpty } from 'ember-utils';
import injectService from 'ember-service/inject';
import { isFollowingColumnInteractive } from 'web-client/utilities/interactivity';

export default Route.extend({
  navigation: injectService(),

  isInteractive(interactiveComponents) {
    let boxArtRendered = interactiveComponents['directory-game'];
    return isFollowingColumnInteractive(interactiveComponents) && boxArtRendered;
  },

  activate() {
    this.get('navigation').setSelected('Games');
  },

  buildPageTitle() {
    return {title: i18n('All Games')};
  },

  setupController(controller) {
    let games = controller.get('games');

    if (!isEmpty(games)) {
      return;
    }

    let options = {kind: 'top', limit: 40};

    this.store.query('game', options).then(results => {
      games.pushObjects(results.toArray());
    });
  },

  actions: {
    loadMoreTopGames() {
      let games = this.get('controller.games');
      let options = {kind: 'top', limit: 60, offset: games.length};

      this.store.query('game', options).then((results) => {
        results.forEach((game) => {
          if (!games.includes(game)) {
            games.pushObject(game);
          }
        });
      });
    }
  }
});
