/* globals i18n */

import Route from 'ember-route';
import injectService from 'ember-service/inject';
import RSVP from 'rsvp';

export default Route.extend({
  vodCoviews: injectService(),
  vodGameInfo: injectService(),
  languageDirectoryFilter: injectService(),
  navigation: injectService(),
  browse: injectService(),

  activate() {
    let selected = this.get('browse.isBrowseExperimentEnabled') ? 'Popular' : 'Videos';

    this.get('navigation').setSelected(selected);
  },

  beforeModel() {
    this._super(...arguments);

    let coviews = this.get('vodCoviews').checkExperiment().then(() => {
      return this.get('vodCoviews').findVodCoviews();
    });
    let vodGameInfo = this.get('vodGameInfo').checkExperiment();

    return RSVP.all([coviews, vodGameInfo]);
  },

  buildPageTitle() {
    return {title: i18n('All Videos')}; // TODO: untranslated
  },

  actions: {
    handleVideoClick(video, position, total) {
      // bubble action to application route
      let applicationRoute = this.container.lookup('route:application');
      let actionHandler = applicationRoute.actions['handleVideoClick'];
      actionHandler.call(applicationRoute, video, position, total);
    },
    refreshModel() {
      this.refresh();
    }
  }
});
