import Route from 'ember-route';
import VideoTypeMixin from 'web-client/mixins/video-type';
import { isFollowingColumnInteractive } from 'web-client/utilities/interactivity';

export default Route.extend(VideoTypeMixin, {
  model({ videoType }) {
    return this._modelForVideoType({
      videoType,
      defaultRoute: 'directory.videos.video-type',
      searchParams: {},
      videoCollection: 'top'
    });
  },

  isInteractive(interactiveComponents) {
    return isFollowingColumnInteractive(interactiveComponents) &&
      (interactiveComponents['beacon:directory-videos-list-empty'] || interactiveComponents['video/preview-card']);
  }
});
