/* globals i18n */

import Route from 'ember-route';
import injectService from 'ember-service/inject';

const SUCCESS_MESSAGE = i18n('Your email address has been successfully validated.');
const ERROR_MESSAGE = i18n("Couldn't validate your email: {{error}}");

export default Route.extend({
  api: injectService(),
  model(params) {
    return this.get('api').request('get', `/v5/emailvalidator/${params.opaque_id}`)
    .then(() => {
      return { msg: SUCCESS_MESSAGE };
    }).catch((err) => {
      return { error: ERROR_MESSAGE.replace("{{error}}", err.responseJSON.error) };
    });
  }
});
