import Route from 'ember-route';
import Ember from 'ember';

const { inject } = Ember;

export default Route.extend({
  session: inject.service(),

  beforeModel() {
    this._super(...arguments);

    let session = this.get('session');
    return session.getCurrentUser().then(
      (userData) => {
        if (!userData.is_staff || !userData.is_admin) {
          this.replaceWith('channel.index', 'feed');
        }
      },
      () => {
        this.replaceWith('channel.index', 'feed');
      }
    );
  }
});
