/* globals i18n */

import $ from 'jquery';
import Route from 'ember-route';
import injectService from 'ember-service/inject';

export default Route.extend({
  session: injectService(),
  layout: injectService(),

  activate() {
    this.set('layout.showRightColumn', false);
  },

  exit() {
    this.set('layout.showRightColumn', true);
  },

  beforeModel() {
    this._super(...arguments);

    if (!this.get('session').isAuthenticated) {
      $.login({mpSourceAction: 'friends-require-login'});
    }
  },

  buildPageTitle() {
    return {title: i18n('Requests')};
  }
});
