import Route from 'ember-route';
import injectService from 'ember-service/inject';
import on from 'ember-evented/on';

export default Route.extend({
  experiments: injectService(),
  persistentPlayer: injectService(),
  layout: injectService(),

  isSubNavExperiment: null,

  setFullSize: on('activate', function() {
    this.set('persistentPlayer.canBeFullSize', true);
  }),

  unsetFullSize: on('deactivate', function() {
    this.set('persistentPlayer.canBeFullSize', false);
    this.set('persistentPlayer.lockedInFullSize', false);
  }),

  beforeModel() {
    this._super(...arguments);

    this.get('experiments').getExperimentValue('CPR_SUB_NAV_V2').then(value => {
      this.set('isSubNavExperiment', value === 'new');
    });
  },

  actions: {
    showPlayer() {
      this.get('persistentPlayer').setMini(false);
      return true;
    },

    shrinkPlayer() {
      // intercept the action if we want to lock the
      // player in place
      if (this.get('persistentPlayer.lockedInFullSize') || this.get('persistentPlayer.isMini')) {
        return false;
      }

      return true;
    },

    anchorPlayer() {
      this.set('persistentPlayer.lockedInFullSize', false);

      if (this.get('persistentPlayer.isFullSize')) {
        return false;
      }

      return true;
    },

    hideMiniPlayer() {
      this.get('persistentPlayer').setMini(false);
      this.set('persistentPlayer.lockedInFullSize', true);
    },

    returnToPlayerRoute() {
      if (this.get('isSubNavExperiment')) {
        this.get('layout').scrollTo(0);
      } else {
        this.get('layout').scrollTo(this.get('layout.channelCoverHeight'));
      }

      return true;
    }
  }
});
