/* global mobileNotification */

import Route from 'ember-route';
import injectService from 'ember-service/inject';
import run from 'ember-runloop';
import StreamModel from 'web-client/models/deprecated-stream';

export default Route.extend({
  ttLocation: 'home',
  layout: injectService(),
  tracking: injectService(),
  geo: injectService(),
  headData: injectService(),
  feeds: injectService(),

  hasNewsFeed: false,

  _fetchFeaturedStreams(geo, lang) {
    let params = { geo, lang, limit: 6 };
    return StreamModel.find('featured', params).load(true);
  },

  _fetchLiveStreams() {
    let params = { startLimit: 6 };
    return StreamModel.find('top', params).load();
  },

  _fetchPSFourStreams() {
    let params = { limit: 6 };
    return StreamModel.find('psFour', params).load();
  },

  _fetchXBoxStreams() {
    let params = { limit: 6 };
    return StreamModel.find('xbOne', params).load();
  },

  _trackCarouselDisplay(featuredStreams) {
    let data = {};

    featuredStreams.forEach((stream, i) => {
      data[`carousel_slot_${i}_channel`] = stream.channel.name;
      data[`carousel_slot_${i}_priority`] = stream.featured_priority;
      data[`carousel_slot_${i}_game`] = stream.game;
    });

    data.platform = 'web';

    this.get('tracking').trackEvent({
      event: 'carousel_display',
      services: ['mixpanel', 'spade'],
      data
    });
  },

  renderTemplate() {
    if (this.get('hasNewsFeed')) {
      return this.render('index-newsfeed');
    }

    return this._super(...arguments);
  },

  setupController(controller) {
    // Display the popup for mobile browsers prompting users to install our
    // mobile app.
    mobileNotification();

    this.get('geo').getGeo().then(response => {
      return this._fetchFeaturedStreams(response.geo, response['received_language']);
    }).then(featuredStreams => {
      run(() => {
        this._trackCarouselDisplay(featuredStreams);
        controller.set('featuredStreams', featuredStreams);
        controller.set('selectedStream', {
          stream: featuredStreams.objectAt(0),
          index: 0
        });
      });
    });

    if (!this.get('hasNewsFeed')) {
      controller.setProperties({
        liveStreams: this._fetchLiveStreams(),
        psFourStreams: this._fetchPSFourStreams(),
        xboxStreams: this._fetchXBoxStreams()
      });
    }
  },

  isInteractive(interactiveComponents) {
    if (this.get('hasNewsFeed')) {
      return interactiveComponents['front-page/carousel-player'] &&
        interactiveComponents['twitch-feed/composer'] &&
        interactiveComponents['front-page/news-feed/streams'];
    }

    return interactiveComponents['front-page/carousel-player'];
  },

  beforeModel() {
    this._super(...arguments);

    return this.get('feeds').hasNewsFeed().then(hasNewsFeed => {
      this.set('hasNewsFeed', hasNewsFeed);
      if (!hasNewsFeed) {
        this.set('layout.bypassApplicationLayout', true);
      }
    });
  },

  activate() {
    this.set('headData.alternateLinks', [
      'android-app://tv.twitch.android.app/twitch/open',
      'ios-app://460177396/twitch/open'
    ]);
  },

  deactivate() {
    this.set('headData.alternateLinks', undefined);
    if (!this.get('hasNewsFeed')) {
      this.set('layout.bypassApplicationLayout', false);
    }
    return this._super(...arguments);
  }
});
