import Route from 'ember-route';
import injectService from 'ember-service/inject';
import { EXPERIMENT_NAME, PERPETUA_ALLOW_GROUP } from 'web-client/utilities/video/playlist';

export default Route.extend({
  experiments: injectService(),

  beforeModel() {
    this._super(...arguments);

    return this.get('experiments').getExperimentValue(EXPERIMENT_NAME).then((value) => {
      if (!PERPETUA_ALLOW_GROUP.includes(value)) {
        this.transitionTo('manager');
      }
    });
  }
});
