import Route from 'ember-route';
import injectService from 'ember-service/inject';

export default Route.extend({
  paginator: injectService(),

  model() {
    let channelName = this.modelFor('user').get('name');
    return this.get('store').findRecord('channel', channelName).then(channelModel => {
      return this.get('paginator').paginatorFor({
        model: channelModel,
        relationshipName: 'collections',
        pageFactory: 'collection'
      });
    });
  },

  actions: {
    createCollection(collectionData) {
      collectionData.owner_id = this.modelFor('user').get('_id');
      this.get('store').createRecord('video-playlist', collectionData).save().then((collection) => {
        this.transitionTo('manager.collections.edit', collection);
      });
    },
    editCollection(collection) {
      this.transitionTo('manager.collections.edit', collection);
    }
  }
});
