/* globals i18n */

import Ember from 'ember';
import Route from 'ember-route';
import VideoManagerProperties from 'web-client/models/video-manager-properties';
const { inject } = Ember;

export default Route.extend({
  ttLocation: 'highlighter',
  store: inject.service(),

  model(params) {
    return this.get('store').findRecord('video', params.videoId);
  },

  afterModel(video) {
    this._super(...arguments);
    return VideoManagerProperties.findOne(this.modelFor('user').id).load(true).then((properties) => {
      video.set('youtubeConnected', properties.get('youtube_connected'));
      video.set('liveAnnotationsEnabled', properties.get('live_annotations_enabled'));
    });
  },

  activate() {
    this.controllerFor('manager').set('isHighlighter', true);
  },

  deactivate() {
    this.controllerFor('manager').set('isHighlighter', false);
  },

  buildPageTitle() {
    return { title: i18n('Highlight Broadcast') };
  },

  actions: {
    willTransition() {
      this.controller.resetState();
      this._super(...arguments);
    }
  }
});
