import Route from 'ember-route';

const HIGHLIGHT_LIMIT = 8;

export default Route.extend({
  currentOffset: 0,

  model() {
    return this.get('store').query('manager/highlight-video', {
      channel: this.modelFor('user').get('id'),
      limit: HIGHLIGHT_LIMIT
    }).then((payload) => {
      this.set('currentOffset', payload.content.length);
      return {
        content: payload,
        videos: this.get('store').peekAll('manager/highlight-video')
      };
    });
  },

  _fetchMoreHighlightVideos() {
    return this.get('store').query('manager/highlight-video', {
      channel: this.modelFor('user').get('id'),
      limit: HIGHLIGHT_LIMIT,
      offset: this.get('currentOffset')
    }).then((payload) => {
      this.set('currentOffset', (this.get('currentOffset') + payload.content.length));
      return { content: payload };
    });
  },

  actions: {
    loadMoreHighlights() {
      return this._fetchMoreHighlightVideos();
    }
  }
});
