import Route from 'ember-route';

const BROADCAST_LIMIT = 8;

export default Route.extend({
  model() {
    return this.get('store').query('manager/past-broadcast-video', {
      channel: this.modelFor('user').get('id'),
      limit: BROADCAST_LIMIT
    }).then((payload) => {
      this.set('currentOffset', payload.content.length);
      return {
        content: payload,
        videos: this.get('store').peekAll('manager/past-broadcast-video')
      };
    });
  },

  _fetchMorePastBroadcasts() {
    return this.get('store').query('manager/past-broadcast-video', {
      channel: this.modelFor('user').get('id'),
      limit: BROADCAST_LIMIT,
      offset: this.get('currentOffset')
    }).then((payload) => {
      this.set('currentOffset', (this.get('currentOffset') + payload.content.length));
      return { content: payload };
    });
  },

  actions: {
    loadMorePastBroadcasts() {
      return this._fetchMorePastBroadcasts();
    }
  }
});
