import Route from 'ember-route';

export default Route.extend({
  model() {
    let userId = this.modelFor('user').get('_id');
    return this.get('store').query('video-playlist', { userId });
  },

  actions: {
    createCollection(collectionData) {
      collectionData.owner_id = this.modelFor('user').get('_id');
      this.get('store').createRecord('video-playlist', collectionData).save().then((collection) => {
        this.transitionTo('manager.collections.edit', collection);
      });
    },
    
    editCollection(collection) {
      this.transitionTo('manager.collections.edit', collection);
    }
  }
});
