import ExtensionsBaseRoute from './base';
import RSVP from 'rsvp';

export default ExtensionsBaseRoute.extend({
  model(params) {
    this._super(...arguments);
    let userData = this.get('session.userData');
    let areExtensionsEnabled = RSVP.resolve(userData.is_staff);
    let extension = this.getExtension(params.extensionId).then(
      ext => ext,
      () => this.returnToExtensionDiscovery()
    );
    let extensionInstallation = this.get('store').query('extension-installation', {
      channelId: userData.id
    }).then(
      extensions => extensions.find(a => a.get('extension.id') === params.extensionId),
      () => null
    );

    return RSVP.hash({
      areExtensionsEnabled,
      extension,
      extensionInstallation
    });
  }
});
