import Route from 'ember-route';
import injectService from 'ember-service/inject';
import $ from 'jquery';
import computed from 'ember-computed';
import { JTV_USER_PICTURES_404_USER_70X70_URL } from 'web-client/utilities/urls/static-cdn';

export default Route.extend({
  session: injectService(),
  experiments: injectService(),
  api: injectService(),
  geo: injectService('premium-geo'),

  isStaff: computed.alias('session.userData.is_staff'),

  showPrimeContent: computed.alias('geo.showPrimeContent'),

  showTwitchPrime: computed.readOnly('showPrimeContent'),
  user: computed.alias('session.userModel'),
  beforeModel(transition) {
    this._super(...arguments);

    if (!this.get('session.isAuthenticated')) {
      transition.abort();
      $.login({ mpSourceAction: 'page-requires-login'});
    }
  },

  model() {
    return this.get('store').find('user', this.get('user.id'));
  },

  afterModel(user) {
    this._super(...arguments);
    let settingsController = this.controllerFor('settings');
    if (this.showTwitchPrime) {
      settingsController.set('showTwitchPrime', true);
      if (!user.has_turbo) {
        settingsController.set('hideTurboTab', true);
      }
    }

    this.get('experiments').getExperimentValue('EXTENSIONS').then(value => {
      if (this.isDestroyed) { return; }
      let isStaff = this.get('isStaff');
      settingsController.set('showExtensions', isStaff && value === 'yes');
    });

    user.set('defaultLogo', JTV_USER_PICTURES_404_USER_70X70_URL);
    user.set('updatedDisplayName', user.get('displayName'));
  }
});
