import Route from 'ember-route';
import injectService from 'ember-service/inject';
import TrackBttv from 'web-client/mixins/track-bttv';

// Only allow these
const WHITELIST_CHANNELS = [ 'playbreakaway', 'breakstreamtest' ];

export default Route.extend(TrackBttv, {
  layout: injectService(),

  model(params) {
    let channel = params.channel;
    if (!WHITELIST_CHANNELS.includes(channel)) {
      this.transitionTo('channel.index', channel);
    }
    return channel;
  },

  activate() {
    this.set('layout.showRightColumn', true);
  }
});
