import Route from 'ember-route';
import get from 'ember-metal/get';
import ChannelModel from 'web-client/models/deprecated-channel';

export default Route.extend({
  model(params) {
    return ChannelModel.find({id: params.channel.toLowerCase()}).load()
      .catch((model) => {
        if (model.get && model.get('error.status') === 404) {
          model.set('notFound', true);
        }
        return model;
      });
  },

  serialize(channel) {
    return {channel: get(channel, 'id')};
  }
});
