/* globals Twitch */

import Route from 'ember-route';

import ChannelModel from 'web-client/models/deprecated-channel';

export default Route.extend({

  model(params) {
    return ChannelModel.find({id: params.channel.toLowerCase()});
  },

  afterModel(model) {
    Twitch.tracking.funnel.addProperties({
      medium: 'youtube',
      content: 'youtube-annotation'
    });
    this.controllerFor('youtube-redirect').set('youtubeRedirect', true);
    this.transitionTo('channel', model.load());
    this._super(...arguments);
  }

});
