import AudreySerializer from './audrey';
import { normalizeReactions } from '../utilities/reactions';

export default AudreySerializer.extend({
  readMeta (payload) {
    return {
      total: payload._total,
      cursor: payload._cursor
    };
  },

  getRootNode (payload) {
    return payload.comments ? payload.comments : payload;
  },

  normalize(modelClass, payload) {
    if (payload.reactions) {
      payload.reactions = normalizeReactions(payload.reactions);
    }
    return this._super(...arguments);
  }
});
