import ApplicationSerializer from './application';
import { EXTENSION_ID_VERSION_SEPARATOR } from 'web-client/adapters/extension';

export default ApplicationSerializer.extend({
  extractId(modelClass, resourceHash) {
    let { id, version } = resourceHash.attributes;
    return `${id}${EXTENSION_ID_VERSION_SEPARATOR}${version}`;
  },

  extractAttributes(type, resourceHash) {
    resourceHash.attributes.client_id = resourceHash.attributes.id;
    return this._super(type, resourceHash);
  },

  normalizeSingleResponse(store, type, payload, id, requestType) {
    let data = { type: 'extension', attributes: payload };
    return this._super(store, type, { data }, id, requestType);
  },

  normalizeArrayResponse(store, type, payload, id, requestType) {
    let extensions = payload.extensions || [];
    let data = extensions.map(attributes => {
      return { type: 'extension', attributes };
    });
    return this._super(store, type, { data }, id, requestType);
  }
});
