import ApplicationSerializer from './application';

let _deserializeFollow = (id, payload) => {
  let isFollowing = payload.is_following;
  let notifications = payload.notifications;

  return {
    type: 'follow',
    id,
    attributes: {
      is_following: isFollowing,
      notifications
    },
    relationships: {
      channel: {
        data: {
          type: 'channel',
          id
        }
      }
    }
  };
};

export default ApplicationSerializer.extend({
  normalizeResponse(store, type, payload, id, requestType) {
    let data = _deserializeFollow(id, payload);
    return this._super(store, type, { data }, id, requestType);
  }
});
