import JSONSerializer from 'ember-data/serializers/json';
import { JTV_USER_PICTURES_404_USER_70X70_URL } from 'web-client/utilities/urls/static-cdn';

export default JSONSerializer.extend({
  isNewSerializerAPI: true,

  _normalizeUser(user) {
    let _user = {
      id: (user._id || user.id).toString(),
      type: 'friends-list-user',
      attributes: {
        avatar: user.logo || JTV_USER_PICTURES_404_USER_70X70_URL,
        displayName: user.display_name,
        login: user.login || user.name || user.display_name.toLowerCase()
      }
    };

    if (user.created_at) {
      _user.attributes.createdAt = user.created_at;
    }

    return _user;
  },

  normalizeCreateRecordResponse(store, klass, payload) {
    if (payload.action === 'friend') {
      return {
        data: {
          id: payload.params.friendId,
          type: 'friends-list-request',
          attributes: {
            friendId: payload.params.friendId,
            friendLogin: payload.params.friendLogin,
            isPending: true
          }
        },

        included: [{
          type: 'friends-list-user',
          id: payload.params.friendId,
          attributes: {
            isRequested: true
          }
        }]
      };
    }
  },

  normalizeQueryRecordResponse(store, klass, payload) {
    if (payload.action === 'accept' || payload.action === 'reject') {
      return {
        data: {
          id: payload.params.friendId,
          type: 'friends-list-request',
          attributes: {
            friendId: payload.params.friendId,
            friendLogin: payload.params.friendLogin,
            isPending: false,
            isAccepted: payload.action === 'accept'
          }
        },

        included: [{
          id: payload.params.friendId,
          type: 'friends-list-user',
          attributes: {
            isFriend: payload.action === 'accept',
            isRequested: false,
            isRequestedBy: false
          }
        }]
      };
    }

    return this._super(...arguments);
  },

  normalizeQueryResponse(store, klass, payload) {
    if (!payload) {
      return { errors: [] };
    }

    // This is a hack... ember-data doesn't support top-level meta yet. See:
    //
    // https://github.com/emberjs/data/issues/3419
    // https://github.com/emberjs/data/pull/3398
    if (typeof payload.count === 'number') {
      return {
        data: [],
        meta: { 'notifications-count': payload.count }
      };
    }

    let requests = [],
        users = [];

    payload.requests.forEach(request => {
      requests.push({
        id: request.user._id,
        type: 'friends-list-request',
        attributes: {
          createdAt: request.user.created_at,
          friendId: request.user._id,
          friendLogin: request.user.name,
          isPending: true,
          isStranger: request.is_stranger,
          isRecommended: request.is_recommended,
          nonStrangerReason: request.non_stranger_reason
        },

        relationships: {
          user: {
            data: {
              type: 'friends-list-user',
              id: request.user._id
            }
          }
        }
      });

      users.push(
        this._normalizeUser(request.user)
      );
    });

    return {
      data: requests,
      included: users
    };
  }
});
