import ApplicationSerializer from './application';

let _deserialize = function (payload) {
  let hash = {};
  let data = {
    type: 'game-detail',
    id: payload.product.asin,
    attributes: {
      action_details: payload.action_details,
      premium_eligibility: payload.premium_eligibility,
      product: payload.product,
      user_entitlement: payload.user_entitlement
    }
  };
  hash.data = data;
  return hash;
};

export default ApplicationSerializer.extend({
  normalizeQueryRecordResponse(store, type, payload, id) {
    let hash = _deserialize(payload);
    return this._super(store, type, hash, id);
  }
});
