/* global uuid */
import JSONSerializer from 'ember-data/serializers/json';

export default JSONSerializer.extend({
  primaryKey: 'id',

  normalize(typeClass, resourceHash) {
    let response = this._super(...arguments);
    response.included = !Array.isArray(resourceHash.releases) ? [] : resourceHash.releases.map((item) => {
      let video = this.store.normalize('video', item).data;
      video.id = item._id;
      return video;
    });
    return response;
  },

  normalizeQueryResponse(store, primaryModelClass, payload) {
    return this._super(store, primaryModelClass, payload.new_releases);
  },

  extractId(modelClass, resourceHash) {
    return resourceHash.game || uuid();
  },

  extractRelationships(modelClass, resourceHash) {
    let game = resourceHash.game || '';
    let itemData = !Array.isArray(resourceHash.releases) ? [] : resourceHash.releases.map((item) => {
      return {
        id: item._id,
        type: 'video'
      };
    });
    return { videos: { data: itemData }, game };
  }
});
