import VideoSerializer from 'web-client/serializers/video';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';

export default VideoSerializer.extend({
  attrs: {
    createdAt: { key: 'created_at' },
    descriptionHTML: { serialize: false },
    length: { serialize: false },
    notifications: { serialize: true },
    preview: { serialize: false },
    publishedAt: { serialize: false },
    status: { serialize: false },
    thumbnails: { serialize: false },
    type: { key: 'broadcast_type' },
    viewable: { serialize: false }
  },

  normalizeQueryResponse(store, primaryModelClass, payload) {
    let data = payload.videos.map((video) => {
      let attributes = this.extractAttributes(primaryModelClass, video);
      return {
        id: normalizeVideoId(video._id),
        type: 'manager/past-broadcast-video',
        relationships: this.extractRelationships(primaryModelClass, video),
        attributes
      };
    });
    return { data };
  },

  normalizeUpdateRecordResponse(store, primaryModelClass, payload, id) {
    let attributes = this.extractAttributes(primaryModelClass, payload);
    return {
      data: {
        id: id,
        type: 'manager/past-broadcast-video',
        attributes
      }
    };
  }
});
