import ApplicationSerializer from './application';

let _deserialize = function (payload) {
  return {
    data: {
      type: 'offline-playlist',
      id: payload.id,
      attributes: {
        version: payload.version,
        // Ember converts this to `vodIds` on the model thanks to `keyForAttribute`
        vod_ids: payload.playlist.vod_ids
      },
      relationships: {
        channel: {
          data: {
            type: 'offline-playlist-channel',
            id: payload.channel_id
          }
        }
      }
    }
  };
};

export default ApplicationSerializer.extend({
  normalizeUpdateRecordResponse(store, type, payload, id) {
    let hash = _deserialize(payload);

    return this._super(store, type, hash, id);
  },
  normalizeCreateRecordResponse(store, type, payload, id) {
    let hash = _deserialize(payload);

    return this._super(store, type, hash, id);
  }

});
